---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Allocation Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestAllocationAction.java` 行66-198
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行6

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cat/allocation と GET /_cat/allocation/{nodes} | E-01 行72 | ○ |
| C-02 | ノードフィルタのデフォルトは "data:true" | E-01 行87 | ○ |
| C-03 | ClusterStateRequest で routingTable=true | E-01 行89 | ○ |
| C-04 | NodesStatsRequest で FS + Store | E-01 行101-103 | ○ |
| C-05 | 9カラムの定義 | E-01 行122-131 | ○ |
| C-06 | allShards() でシャード数集計 | E-01 行138-146 | ○ |
| C-07 | disk.used の計算: total - avail | E-01 行161 | ○ |
| C-08 | disk.percent の計算: (short)(used * 100 / (used + avail)) | E-01 行163 | ○ |
| C-09 | UNASSIGNED行の出力条件 | E-01 行180-193 | ○ |
| C-10 | 負の値やゼロの場合のnull表示 | E-01 行159-160, 170-173 | ○ |
| C-11 | 2段階のAPI呼び出し（State → Stats） | E-01 行96-113 | ○ |
| C-12 | UNASSIGNED行のディスクカラムはnull | E-01 行183-188 | ○ |
| C-13 | allocs.merge でシャードカウント | E-01 行145 | ○ |
| C-14 | 帳票一覧での定義内容 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンパクトなクラスで全処理が明確

## 6) レビュアーチェックリスト（最小）
- [ ] disk.percent の計算式がソースコードと一致しているか
- [ ] UNASSIGNED行の出力条件と内容が正確か
- [ ] ノードフィルタのデフォルト値 "data:true" が正しいか
